//main.c AtTiny84 Blink example

#include <avr/io.h>
#include <util/delay.h>

#define F_CPU 16000000
#define BUTTON_PRESSED	!(PINA & (1<<PA3))		// check for button press
#define LED_ON	PORTA |= (1 << PA0)			// turn LED on code
#define LED_OFF	PORTA &= ~(1<< PA0)			// turn LED off code

typedef unsigned char  BYTE;
typedef unsigned short WORD;

void signal(){
	LED_ON;
	_delay_ms(500);
	LED_OFF;
	_delay_ms(500);
	LED_ON;
	_delay_ms(500);
	LED_OFF;
	_delay_ms(500);
	LED_ON;
	_delay_ms(500);
	LED_OFF;
	_delay_ms(500);
}

int main (void) {
	// declare PA0 as output pin. This is where the motor and LED is connected
	DDRA = (1 << PA0);
	DDRA |= (0 << DDA3);	// using A3 as button input
	PORTA |= (0 << PA3);	// pull-up resistor


	// main loop
	while (1) {

		if (!BUTTON_PRESSED){
		   signal();
		}

	}
	return 1;
}
