/*
 * LCD_FabAcademy.c
 *
 * Created: 02.05.2017 23:26:54
 * Author : Florian Paproth
 */

#define F_CPU 16000000  // Important to set the correct CPU freq for the display and for delay

#define LED_ON  PORTD |= (1 << PD7)         // turn LED on code
#define LED_OFF PORTD &= ~(1<< PD7)         // turn LED off code

#include <stdio.h>
#include "lcd-routines.h" // Import the LCD library
#include <avr/io.h>
#include <util/delay.h>


void setTime(int uptime){
    lcd_clear();
    lcd_home();
    // Set the FabAcademy text
    lcd_string("FloKit uptime");

    lcd_setcursor( 0, 2 );

     char Buffer[20]; // in diesem {} lokal
     itoa( uptime, Buffer, 10 );

    lcd_string( strcat(Buffer , " sec") );
}

int main(void)
{
    // Initialize the LCD
    lcd_init();

    int uptime = 0;

    while(1)
    {
        _delay_ms(500);
        LED_OFF;
        _delay_ms(500);
        LED_ON;
        uptime++;

        setTime(uptime);
    }

    return 0;
}